/*
 * TreeItem.h
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#ifndef TREEITEM_H_
#define TREEITEM_H_

#include <QObject>
#include <QVariant>
#include <QVector>
#include <QString>
#include <QList>
#include <QFont>


class TreeItem : public QObject
{
	Q_OBJECT
public:
	typedef enum
	{
		ROOT,
		READER,
		ANTENNA,
		TAG,
		INFO
	} TYPE;

	typedef enum
	{
		VALUE,
		PROGRESSBAR
	} DISPLAY_TYPE;

	typedef enum
	{
		COL_ID = 0,
		COL_TagType,
		COL_ReadCount,
		COL_ReadRate,
		COL_Action,
		COL_State
	} COLUMN_INDEX;

public:
	TreeItem(TreeItem* parent = 0);
	virtual ~TreeItem();

public:
	virtual void		updateDynamicInfo();
	virtual void 		clearTags();

public:
    virtual void        inventoryAboutToStart();
	virtual void 		inventoryStarted();
	virtual void 		inventoryStoped();
    virtual void 		inventoryPaused();
    virtual void 		inventoryContinued();

public:
	virtual DISPLAY_TYPE 	displayType() const;

	virtual TreeItem* 	parent() const;

	virtual int			childCount() const;
	virtual TreeItem*	child(int row) const;
	virtual int 		indexOf(TreeItem* t) const;

	virtual int 		row() const;

public:
	virtual TYPE 		itemType() const = 0;

	virtual QVariant 	data(int column, int role) const = 0;

	virtual int 		informationRowCount () const;
	virtual QList<int>	informationSpan() const;
	virtual QVariant	information (int row, int column, int role) const;

public:
	virtual int			progressBarMin() const;
	virtual int			progressBarMax() const;
	virtual QString		progressBarText() const;

protected:
	virtual QBrush 		headingBackgroundColor() const;

protected:
	QList<TreeItem*>	m_children;
	TreeItem* 			m_parent;

	void connectChild ( TreeItem* child );
	void disconnectChild ( TreeItem* child );

	QFont				m_treeBoxFont;
	QFont				m_informationBoxFont;

	QList<int>			m_informationHeader;
	QList<int>			m_informationSubHeader;
	QVector<QString>	m_informationKeys;
	QVector<QString>	m_informationValues;

signals:
	void informationChanged(int first, int last);
	void informationBeginInsertRow(int index);
	void informationEndInsertRow();

	void beginInsertRows ( TreeItem* t, int first, int last );
	void endInsertRows ( );

	void beginRemoveRows ( TreeItem* t, int first, int last );
	void endRemoveRows ( );

	void requestToExpand( TreeItem* t );
	void dataChanged ( TreeItem* t, int leftCol, int rightCol );

	void aboutToBeRemoved ( TreeItem* t );
};

#endif /* TREEITEM_H_ */
